import { MigrationInterface, QueryRunner } from "typeorm";

export class FixUUIDForeignKeys1762909733187 implements MigrationInterface {
    name = 'FixUUIDForeignKeys1762909733187'

    public async up(queryRunner: QueryRunner): Promise<void> {
        await queryRunner.query(`ALTER TABLE \`product_variations\` DROP FOREIGN KEY \`FK_product_variation_product\``);
        await queryRunner.query(`ALTER TABLE \`products\` DROP FOREIGN KEY \`FK_products_category\``);
        await queryRunner.query(`ALTER TABLE \`vendors\` CHANGE \`id\` \`id\` varchar(36) NOT NULL`);
        await queryRunner.query(`ALTER TABLE \`vendors\` DROP COLUMN \`userId\``);
        await queryRunner.query(`ALTER TABLE \`vendors\` ADD \`userId\` int NULL`);
        await queryRunner.query(`ALTER TABLE \`vendors\` ADD UNIQUE INDEX \`IDX_d9a5f2ffcbba018f7b35a3cf79\` (\`userId\`)`);
        await queryRunner.query(`ALTER TABLE \`reviews\` DROP PRIMARY KEY`);
        await queryRunner.query(`ALTER TABLE \`reviews\` DROP COLUMN \`id\``);
        await queryRunner.query(`ALTER TABLE \`reviews\` ADD \`id\` int NOT NULL PRIMARY KEY AUTO_INCREMENT`);
        await queryRunner.query(`ALTER TABLE \`reviews\` DROP COLUMN \`rating\``);
        await queryRunner.query(`ALTER TABLE \`reviews\` ADD \`rating\` int NOT NULL`);
        await queryRunner.query(`ALTER TABLE \`products\` DROP COLUMN \`vendorId\``);
        await queryRunner.query(`ALTER TABLE \`products\` ADD \`vendorId\` varchar(36) NULL`);
        await queryRunner.query(`ALTER TABLE \`products\` DROP COLUMN \`createdAt\``);
        await queryRunner.query(`ALTER TABLE \`products\` ADD \`createdAt\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6)`);
        await queryRunner.query(`ALTER TABLE \`products\` DROP COLUMN \`updatedAt\``);
        await queryRunner.query(`ALTER TABLE \`products\` ADD \`updatedAt\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6)`);
        await queryRunner.query(`ALTER TABLE \`transactions\` DROP PRIMARY KEY`);
        await queryRunner.query(`ALTER TABLE \`transactions\` DROP COLUMN \`id\``);
        await queryRunner.query(`ALTER TABLE \`transactions\` ADD \`id\` int NOT NULL PRIMARY KEY AUTO_INCREMENT`);
        await queryRunner.query(`ALTER TABLE \`transactions\` CHANGE \`amount\` \`amount\` decimal(10,2) NOT NULL`);
        await queryRunner.query(`ALTER TABLE \`transactions\` DROP COLUMN \`status\``);
        await queryRunner.query(`ALTER TABLE \`transactions\` ADD \`status\` varchar(255) NOT NULL DEFAULT 'success'`);
        await queryRunner.query(`ALTER TABLE \`orders\` DROP PRIMARY KEY`);
        await queryRunner.query(`ALTER TABLE \`orders\` DROP COLUMN \`id\``);
        await queryRunner.query(`ALTER TABLE \`orders\` ADD \`id\` int NOT NULL PRIMARY KEY AUTO_INCREMENT`);
        await queryRunner.query(`ALTER TABLE \`carts\` DROP PRIMARY KEY`);
        await queryRunner.query(`ALTER TABLE \`carts\` DROP COLUMN \`id\``);
        await queryRunner.query(`ALTER TABLE \`carts\` ADD \`id\` int NOT NULL PRIMARY KEY AUTO_INCREMENT`);
        await queryRunner.query(`ALTER TABLE \`carts\` CHANGE \`quantity\` \`quantity\` int NOT NULL`);
        await queryRunner.query(`DROP INDEX \`REL_b8512aa9cef03d90ed5744c94d\` ON \`customers\``);
        await queryRunner.query(`ALTER TABLE \`customers\` DROP COLUMN \`userId\``);
        await queryRunner.query(`ALTER TABLE \`customers\` ADD \`userId\` int NULL`);
        await queryRunner.query(`ALTER TABLE \`customers\` ADD UNIQUE INDEX \`IDX_b8512aa9cef03d90ed5744c94d\` (\`userId\`)`);
        await queryRunner.query(`ALTER TABLE \`users\` DROP PRIMARY KEY`);
        await queryRunner.query(`ALTER TABLE \`users\` DROP COLUMN \`id\``);
        await queryRunner.query(`ALTER TABLE \`users\` ADD \`id\` int NOT NULL PRIMARY KEY AUTO_INCREMENT`);
        await queryRunner.query(`ALTER TABLE \`users\` DROP COLUMN \`role\``);
        await queryRunner.query(`ALTER TABLE \`users\` ADD \`role\` varchar(255) NOT NULL DEFAULT 'customer'`);
        await queryRunner.query(`ALTER TABLE \`users\` ADD UNIQUE INDEX \`IDX_c6c520dfb9a4d6dd749e73b13d\` (\`customerId\`)`);
        await queryRunner.query(`ALTER TABLE \`users\` DROP COLUMN \`vendorId\``);
        await queryRunner.query(`ALTER TABLE \`users\` ADD \`vendorId\` varchar(36) NULL`);
        await queryRunner.query(`ALTER TABLE \`users\` ADD UNIQUE INDEX \`IDX_a6b1305fa3dcef6630c3735734\` (\`vendorId\`)`);
        await queryRunner.query(`ALTER TABLE \`business_settings\` DROP PRIMARY KEY`);
        await queryRunner.query(`ALTER TABLE \`business_settings\` DROP COLUMN \`id\``);
        await queryRunner.query(`ALTER TABLE \`business_settings\` ADD \`id\` int NOT NULL PRIMARY KEY AUTO_INCREMENT`);
        await queryRunner.query(`ALTER TABLE \`business_settings\` ADD UNIQUE INDEX \`IDX_bcc6e4988df408737d6b4c46f4\` (\`key\`)`);
        await queryRunner.query(`ALTER TABLE \`coupons\` DROP PRIMARY KEY`);
        await queryRunner.query(`ALTER TABLE \`coupons\` DROP COLUMN \`id\``);
        await queryRunner.query(`ALTER TABLE \`coupons\` ADD \`id\` int NOT NULL PRIMARY KEY AUTO_INCREMENT`);
        await queryRunner.query(`ALTER TABLE \`coupons\` DROP COLUMN \`code\``);
        await queryRunner.query(`ALTER TABLE \`coupons\` ADD \`code\` varchar(255) NOT NULL`);
        await queryRunner.query(`ALTER TABLE \`coupons\` ADD UNIQUE INDEX \`IDX_e025109230e82925843f2a14c4\` (\`code\`)`);
        await queryRunner.query(`CREATE UNIQUE INDEX \`REL_d9a5f2ffcbba018f7b35a3cf79\` ON \`vendors\` (\`userId\`)`);
        await queryRunner.query(`CREATE UNIQUE INDEX \`REL_b8512aa9cef03d90ed5744c94d\` ON \`customers\` (\`userId\`)`);
        await queryRunner.query(`CREATE UNIQUE INDEX \`REL_c6c520dfb9a4d6dd749e73b13d\` ON \`users\` (\`customerId\`)`);
        await queryRunner.query(`CREATE UNIQUE INDEX \`REL_a6b1305fa3dcef6630c3735734\` ON \`users\` (\`vendorId\`)`);
        await queryRunner.query(`ALTER TABLE \`vendors\` ADD CONSTRAINT \`FK_d9a5f2ffcbba018f7b35a3cf79f\` FOREIGN KEY (\`userId\`) REFERENCES \`users\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`product_variations\` ADD CONSTRAINT \`FK_a5bbc1e7886ded70ebf6a7c6f7d\` FOREIGN KEY (\`productId\`) REFERENCES \`products\`(\`id\`) ON DELETE CASCADE ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`reviews\` ADD CONSTRAINT \`FK_a6b3c434392f5d10ec171043666\` FOREIGN KEY (\`productId\`) REFERENCES \`products\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`reviews\` ADD CONSTRAINT \`FK_6d99bdfa69280ede313699fab92\` FOREIGN KEY (\`customerId\`) REFERENCES \`customers\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`products\` ADD CONSTRAINT \`FK_ff56834e735fa78a15d0cf21926\` FOREIGN KEY (\`categoryId\`) REFERENCES \`categories\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`products\` ADD CONSTRAINT \`FK_6b00af9e9c38a1673f594de74f4\` FOREIGN KEY (\`vendorId\`) REFERENCES \`vendors\`(\`id\`) ON DELETE SET NULL ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`order_details\` ADD CONSTRAINT \`FK_147bc15de4304f89a93c7eee969\` FOREIGN KEY (\`orderId\`) REFERENCES \`orders\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`order_details\` ADD CONSTRAINT \`FK_c67ebaba3e5085b6401911acc70\` FOREIGN KEY (\`productId\`) REFERENCES \`products\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`transactions\` ADD CONSTRAINT \`FK_2fdbbae70ff802bc8b703ee7c5c\` FOREIGN KEY (\`orderId\`) REFERENCES \`orders\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`orders\` ADD CONSTRAINT \`FK_e5de51ca888d8b1f5ac25799dd1\` FOREIGN KEY (\`customerId\`) REFERENCES \`customers\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`carts\` ADD CONSTRAINT \`FK_a4393093f31aabad6de1f54b0e9\` FOREIGN KEY (\`customerId\`) REFERENCES \`customers\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`carts\` ADD CONSTRAINT \`FK_9c77aaa5bc26f66159661ffd808\` FOREIGN KEY (\`productId\`) REFERENCES \`products\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`addresses\` ADD CONSTRAINT \`FK_b5976584943ec93aa5394a55320\` FOREIGN KEY (\`customerId\`) REFERENCES \`customers\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`customers\` ADD CONSTRAINT \`FK_b8512aa9cef03d90ed5744c94d7\` FOREIGN KEY (\`userId\`) REFERENCES \`users\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`users\` ADD CONSTRAINT \`FK_c6c520dfb9a4d6dd749e73b13de\` FOREIGN KEY (\`customerId\`) REFERENCES \`customers\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`users\` ADD CONSTRAINT \`FK_a6b1305fa3dcef6630c37357345\` FOREIGN KEY (\`vendorId\`) REFERENCES \`vendors\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`support_tickets\` ADD CONSTRAINT \`FK_ee952666931bd353d113acdd5de\` FOREIGN KEY (\`customerId\`) REFERENCES \`customers\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
    }

    public async down(queryRunner: QueryRunner): Promise<void> {
        await queryRunner.query(`ALTER TABLE \`support_tickets\` DROP FOREIGN KEY \`FK_ee952666931bd353d113acdd5de\``);
        await queryRunner.query(`ALTER TABLE \`users\` DROP FOREIGN KEY \`FK_a6b1305fa3dcef6630c37357345\``);
        await queryRunner.query(`ALTER TABLE \`users\` DROP FOREIGN KEY \`FK_c6c520dfb9a4d6dd749e73b13de\``);
        await queryRunner.query(`ALTER TABLE \`customers\` DROP FOREIGN KEY \`FK_b8512aa9cef03d90ed5744c94d7\``);
        await queryRunner.query(`ALTER TABLE \`addresses\` DROP FOREIGN KEY \`FK_b5976584943ec93aa5394a55320\``);
        await queryRunner.query(`ALTER TABLE \`carts\` DROP FOREIGN KEY \`FK_9c77aaa5bc26f66159661ffd808\``);
        await queryRunner.query(`ALTER TABLE \`carts\` DROP FOREIGN KEY \`FK_a4393093f31aabad6de1f54b0e9\``);
        await queryRunner.query(`ALTER TABLE \`orders\` DROP FOREIGN KEY \`FK_e5de51ca888d8b1f5ac25799dd1\``);
        await queryRunner.query(`ALTER TABLE \`transactions\` DROP FOREIGN KEY \`FK_2fdbbae70ff802bc8b703ee7c5c\``);
        await queryRunner.query(`ALTER TABLE \`order_details\` DROP FOREIGN KEY \`FK_c67ebaba3e5085b6401911acc70\``);
        await queryRunner.query(`ALTER TABLE \`order_details\` DROP FOREIGN KEY \`FK_147bc15de4304f89a93c7eee969\``);
        await queryRunner.query(`ALTER TABLE \`products\` DROP FOREIGN KEY \`FK_6b00af9e9c38a1673f594de74f4\``);
        await queryRunner.query(`ALTER TABLE \`products\` DROP FOREIGN KEY \`FK_ff56834e735fa78a15d0cf21926\``);
        await queryRunner.query(`ALTER TABLE \`reviews\` DROP FOREIGN KEY \`FK_6d99bdfa69280ede313699fab92\``);
        await queryRunner.query(`ALTER TABLE \`reviews\` DROP FOREIGN KEY \`FK_a6b3c434392f5d10ec171043666\``);
        await queryRunner.query(`ALTER TABLE \`product_variations\` DROP FOREIGN KEY \`FK_a5bbc1e7886ded70ebf6a7c6f7d\``);
        await queryRunner.query(`ALTER TABLE \`vendors\` DROP FOREIGN KEY \`FK_d9a5f2ffcbba018f7b35a3cf79f\``);
        await queryRunner.query(`DROP INDEX \`REL_a6b1305fa3dcef6630c3735734\` ON \`users\``);
        await queryRunner.query(`DROP INDEX \`REL_c6c520dfb9a4d6dd749e73b13d\` ON \`users\``);
        await queryRunner.query(`DROP INDEX \`REL_b8512aa9cef03d90ed5744c94d\` ON \`customers\``);
        await queryRunner.query(`DROP INDEX \`REL_d9a5f2ffcbba018f7b35a3cf79\` ON \`vendors\``);
        await queryRunner.query(`ALTER TABLE \`coupons\` DROP INDEX \`IDX_e025109230e82925843f2a14c4\``);
        await queryRunner.query(`ALTER TABLE \`coupons\` DROP COLUMN \`code\``);
        await queryRunner.query(`ALTER TABLE \`coupons\` ADD \`code\` varchar(100) NOT NULL`);
        await queryRunner.query(`ALTER TABLE \`coupons\` DROP COLUMN \`id\``);
        await queryRunner.query(`ALTER TABLE \`coupons\` ADD \`id\` varchar(36) NOT NULL DEFAULT 'uuid()'`);
        await queryRunner.query(`ALTER TABLE \`coupons\` ADD PRIMARY KEY (\`id\`)`);
        await queryRunner.query(`ALTER TABLE \`business_settings\` DROP INDEX \`IDX_bcc6e4988df408737d6b4c46f4\``);
        await queryRunner.query(`ALTER TABLE \`business_settings\` DROP COLUMN \`id\``);
        await queryRunner.query(`ALTER TABLE \`business_settings\` ADD \`id\` varchar(36) NOT NULL DEFAULT 'uuid()'`);
        await queryRunner.query(`ALTER TABLE \`business_settings\` ADD PRIMARY KEY (\`id\`)`);
        await queryRunner.query(`ALTER TABLE \`users\` DROP INDEX \`IDX_a6b1305fa3dcef6630c3735734\``);
        await queryRunner.query(`ALTER TABLE \`users\` DROP COLUMN \`vendorId\``);
        await queryRunner.query(`ALTER TABLE \`users\` ADD \`vendorId\` int NULL`);
        await queryRunner.query(`ALTER TABLE \`users\` DROP INDEX \`IDX_c6c520dfb9a4d6dd749e73b13d\``);
        await queryRunner.query(`ALTER TABLE \`users\` DROP COLUMN \`role\``);
        await queryRunner.query(`ALTER TABLE \`users\` ADD \`role\` enum ('admin', 'vendor', 'customer') NOT NULL DEFAULT 'customer'`);
        await queryRunner.query(`ALTER TABLE \`users\` DROP COLUMN \`id\``);
        await queryRunner.query(`ALTER TABLE \`users\` ADD \`id\` varchar(36) NOT NULL`);
        await queryRunner.query(`ALTER TABLE \`users\` ADD PRIMARY KEY (\`id\`)`);
        await queryRunner.query(`ALTER TABLE \`customers\` DROP INDEX \`IDX_b8512aa9cef03d90ed5744c94d\``);
        await queryRunner.query(`ALTER TABLE \`customers\` DROP COLUMN \`userId\``);
        await queryRunner.query(`ALTER TABLE \`customers\` ADD \`userId\` varchar(36) NULL`);
        await queryRunner.query(`CREATE UNIQUE INDEX \`REL_b8512aa9cef03d90ed5744c94d\` ON \`customers\` (\`userId\`)`);
        await queryRunner.query(`ALTER TABLE \`carts\` CHANGE \`quantity\` \`quantity\` int NOT NULL DEFAULT '1'`);
        await queryRunner.query(`ALTER TABLE \`carts\` DROP COLUMN \`id\``);
        await queryRunner.query(`ALTER TABLE \`carts\` ADD \`id\` varchar(36) NOT NULL DEFAULT 'uuid()'`);
        await queryRunner.query(`ALTER TABLE \`carts\` ADD PRIMARY KEY (\`id\`)`);
        await queryRunner.query(`ALTER TABLE \`orders\` DROP COLUMN \`id\``);
        await queryRunner.query(`ALTER TABLE \`orders\` ADD \`id\` varchar(36) NOT NULL DEFAULT 'uuid()'`);
        await queryRunner.query(`ALTER TABLE \`orders\` ADD PRIMARY KEY (\`id\`)`);
        await queryRunner.query(`ALTER TABLE \`transactions\` DROP COLUMN \`status\``);
        await queryRunner.query(`ALTER TABLE \`transactions\` ADD \`status\` enum ('pending', 'completed', 'failed', 'cancelled') NULL DEFAULT 'pending'`);
        await queryRunner.query(`ALTER TABLE \`transactions\` CHANGE \`amount\` \`amount\` decimal(12,2) NOT NULL`);
        await queryRunner.query(`ALTER TABLE \`transactions\` DROP COLUMN \`id\``);
        await queryRunner.query(`ALTER TABLE \`transactions\` ADD \`id\` varchar(36) NOT NULL DEFAULT 'uuid()'`);
        await queryRunner.query(`ALTER TABLE \`transactions\` ADD PRIMARY KEY (\`id\`)`);
        await queryRunner.query(`ALTER TABLE \`products\` DROP COLUMN \`updatedAt\``);
        await queryRunner.query(`ALTER TABLE \`products\` ADD \`updatedAt\` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP`);
        await queryRunner.query(`ALTER TABLE \`products\` DROP COLUMN \`createdAt\``);
        await queryRunner.query(`ALTER TABLE \`products\` ADD \`createdAt\` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP`);
        await queryRunner.query(`ALTER TABLE \`products\` DROP COLUMN \`vendorId\``);
        await queryRunner.query(`ALTER TABLE \`products\` ADD \`vendorId\` int NULL`);
        await queryRunner.query(`ALTER TABLE \`reviews\` DROP COLUMN \`rating\``);
        await queryRunner.query(`ALTER TABLE \`reviews\` ADD \`rating\` tinyint NOT NULL`);
        await queryRunner.query(`ALTER TABLE \`reviews\` DROP COLUMN \`id\``);
        await queryRunner.query(`ALTER TABLE \`reviews\` ADD \`id\` varchar(36) NOT NULL DEFAULT 'uuid()'`);
        await queryRunner.query(`ALTER TABLE \`reviews\` ADD PRIMARY KEY (\`id\`)`);
        await queryRunner.query(`ALTER TABLE \`vendors\` DROP INDEX \`IDX_d9a5f2ffcbba018f7b35a3cf79\``);
        await queryRunner.query(`ALTER TABLE \`vendors\` DROP COLUMN \`userId\``);
        await queryRunner.query(`ALTER TABLE \`vendors\` ADD \`userId\` varchar(36) NULL`);
        await queryRunner.query(`ALTER TABLE \`vendors\` CHANGE \`id\` \`id\` varchar(36) NOT NULL DEFAULT 'uuid()'`);
        await queryRunner.query(`ALTER TABLE \`products\` ADD CONSTRAINT \`FK_products_category\` FOREIGN KEY (\`categoryId\`) REFERENCES \`categories\`(\`id\`) ON DELETE SET NULL ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`product_variations\` ADD CONSTRAINT \`FK_product_variation_product\` FOREIGN KEY (\`productId\`) REFERENCES \`products\`(\`id\`) ON DELETE CASCADE ON UPDATE NO ACTION`);
    }

}
